// ------------------------------------
//         pDraft APPLICATION
//            Version 1.26
//      by: Harry Konstas 00/09/02 
// ------------------------------------ 
 
#include "OBL.h" 
#include "HiRes.h" 
 
#define appFileCreator   'pDft'  
#define appVersionNum     0x01  
#define appPrefID         0x00  
#define appPrefVersionNum 0x01  
#define dataVersion       0x02 
  
// tFRM 
#define MainForm 1000 
#define PanButton 1001 
#define SelButton 1002 
#define OrientButton 1003 
#define PlaceButton 1004 
#define CopyButton 1005 
#define UndoButton 1006 
#define DelButton 1007 
#define WireButton 1008 
#define BusButton 1009 
#define JunButton 1010 
#define SymButton 1011 
#define ICButton 1012 
#define GateButton 1013 
#define LabelButton 1014 
#define ElectButton 1015 
#define OrthoButton 1016 
#define GridButton 1017 
 
// File entry + rename tFRMs 
#define RenameForm 1100 
#define FileEntryForm 1300 
#define OKButton 1101 
#define RenameField 1103 
 
// File select tFRM 
#define FileSelectForm 1200 
#define FileList 1201 
#define FOKButton 1202 
 
// MENU  
#define MenuFileNew 1101 
#define MenuFileOpen 1102 
#define MenuFileRename 1103 
#define MenuFileDelete 1104 
#define MenuExportBlock 1201 
#define MenuImportBlock 1202 
#define MenuSheetInfo 1203 
#define MenuSheetErase 1204 
#define MenuExportBitmap 1206 
#define MenuOptionsAbout 1301 
#define MenuOptionsHelp 1302 
 
// Tstr 
#define HelpMsg 1000 
#define InfoAlert 1300 
#define AskAlert 1400 
 
// tSTL 
#define SymbolList 1100 
#define GateList 1200 
#define SampleStr 1210 
#define ElectList 1220 
 
// other 
#define GRIDSPACE 8 
#define SHEETW 800 
#define SHEETH 640 
#define ZOOMLIMIT 300 
#define SYMBMP 1001 
#define GATEBMP 1002 
 
#define sysFtrNumWinVersion  24

#define LIBFILE "pdraft.lib" 
 
// ------------------------------------  
//        STRUCTURES & GLOBALS 
// ------------------------------------ 
 
 
enum editmodes {  
  PANMODE=1, 
  SELMODE, 
  WIREMODE, 
  BUSMODE, 
  JUNMODE, 
  ALPHAMODE, 
  DELMODE 
}; 
 
enum linetypes { 
  THINLINE=1, 
  THICKLINE 
}; 
 
enum drawmodes { 
  DRAWBG=0, 
  DRAWFG=1 
}; 
 
enum idmodes { 
  LIBID=1, 
  BMPID 
}; 
 
enum zoommodes { 
  ZOOM1=1, 
  ZOOM2=2, 
  ZOOM4=4 
}; 
 
enum elecomp { 
  C_JUNCTION=2000, 
  C_WIRE, 
  C_BUS, 
  C_LABEL, 
  C_BITMAP, 
  C_USERLIB 
}; 
 
enum blockmodes { 
  COPYBLOCK=1, 
  DELBLOCK, 
  MOVEBLOCK 
}; 
 
typedef struct { 
  int  id; 
  int  type; 
  int  flip; 
  int  x;  
  int  y; 
  int  w; 
  int  h; 
  char label[60]; 
}SCHDB; 
 
typedef struct { 
  int  type; 
  char label[39]; 
  char flip; 
  int  id; 
  int  x;  
  int  y; 
  int  w; 
  int  h; 
}OLDSCHDB; 
 
typedef struct   
{  
  char fname[40]; 
  int x; 
  int y; 
  int grid; 
  int zoom; 
  int ortho; 
  int futur2; 
  char reserved[40]; 
}PreferenceType;  
 
// Prototypes 
 
int DrawComponent(int win,WinHandle workH, int id, int flip, char *title, int x, int y); 
void DisplaySheet(WinHandle workH, Word originX, Word originY,int grid); 
void DrawSheet(WinHandle workH); 
int WriteSchDB(DmOpenRef db, int index, int type, int id, 
               int flip,char *label, int x, int y, int w, int h); 
 
//Err BmpDelete(BitmapType *pB) SYS_TRAP(sysTrapBmpDelete); 
WinHandle WinCreateBitmapWindow(BitmapType *pB,int *err) SYS_TRAP(sysTrapWinCreateBitmapWindow); 
//BitmapType *BmpCreate(int w,int h,UInt8 d,char *c,int *err) SYS_TRAP(sysTrapBmpCreate); 
 
// Globals 
 
DmOpenRef SCHdb; 
WinHandle SheetHandle; 
 
BitmapType *workB; 
BitmapType  *mainB; 
BitmapTypeV3 *mainV3; 
BitmapTypeV3 *workV3; 
 
int Ortho=1, BlockOper=MOVEBLOCK; 
int grid=GRIDSPACE, HiRes=1; 
int SheetX=0, SheetY=0; 
int SheetW=SHEETW, SheetH=SHEETH; 
int EditMode=PANMODE, OldMode=PANMODE,Zoom=1; 
 
int baseID=0,placeF=0,placeID=0,placeX=0,placeY=0,placeW=0,placeH=0; 
int RegionX=0, RegionY=0, RegionX2=0, RegionY2=0; 
int TargetX=-1, TargetY=-1; 
int ZoomLimit=ZOOMLIMIT, HiZoom=0; 
int OS5 = 0; 
 
char FileName[40],placeN[40]; 
extern char *ItemsBuffer2; 
 
// ------------------------------------  
//             UTILITIES 
// ------------------------------------ 
 
int ColorSupport(void) 
{ 
  Boolean color=0; 
 
  ScrDisplayMode(5,NULL,NULL,NULL,&color); 
  return color; 
 
} 
 
UInt32 GetOS(void) 
{ 
  UInt32 r; 
  UInt16 v; 
 
  FtrGet(sysFtrCreator,sysFtrNumROMVersion,&r); 
  v=r>>20; 
  return v; 
 
} 
 
UInt GetVersion(char *dbname) 
{ 
 
  LocalID id; 
  UInt ver; 
 
  id = DmFindDatabase(0,dbname); 
  DmDatabaseInfo(0,id,NULL,NULL,&ver,NULL, 
      NULL,NULL,NULL,NULL,NULL,NULL,NULL); 
 
  return ver; 
 
} 
 
void SetVersion(char *dbname, UInt version) 
{ 
 
  LocalID id; 
  UInt ver; 
 
 
  id = DmFindDatabase(0,dbname); 
  DmDatabaseInfo(0,id,NULL,NULL,&ver,NULL, 
    NULL,NULL,NULL,NULL,NULL,NULL,NULL); 
 
  ver=version; // set version no 
  DmSetDatabaseInfo(0,id,NULL,NULL,&ver,NULL, 
    NULL,NULL,NULL,NULL,NULL,NULL,NULL); 
 
} 
 
Handle GetTinyFont(int fID) 
{ 
 
  Handle resH; 
  FontPtr pData; 
 
  resH=DmGetResource('tFNT',1000); 
  if(resH==NULL) return NULL; 
 
  pData=MemHandleLock(resH); 
 
  if(FntDefineFont(fID,pData)!=0)  
    return NULL; 
  
  return resH; 
 
} 
 
void DiscardTinyFont(Handle resH) 
{ 
 
  DmReleaseResource(resH); 
  MemHandleUnlock(resH); 
 
} 
 
void ResetMode(void)  
{ 
 
  FormPtr frmP; 
 
  EditMode=PANMODE; 
  SetControlState(PanButton,1);              
  SetControlState(SelButton,0); 
  SetControlState(WireButton,0); 
  SetControlState(BusButton,0); 
  SetControlState(JunButton,0); 
  SetControlState(SymButton,0); 
  SetControlState(ICButton,0); 
  SetControlState(GateButton,0); 
  SetControlState(LabelButton,0); 
  SetControlState(ElectButton,0); 
   
  frmP = FrmGetActiveForm();  
  FrmDrawForm (frmP); 
 
} 
 
void  HideControls(void)  
{ 
 
  FormPtr frmP; 
 
  HideControl(PanButton);              
  HideControl(SelButton); 
  HideControl(OrientButton); 
  HideControl(PlaceButton); 
  HideControl(CopyButton); 
  HideControl(UndoButton); 
  HideControl(DelButton); 
  HideControl(WireButton); 
  HideControl(BusButton); 
  HideControl(JunButton); 
  HideControl(SymButton); 
  HideControl(ICButton); 
  HideControl(GateButton); 
  HideControl(LabelButton); 
  HideControl(ElectButton); 
  HideControl(OrthoButton); 
  HideControl(GridButton); 
   
  frmP = FrmGetActiveForm();  
  FrmDrawForm (frmP); 
 
} 
 
void  ShowControls(void)  
{ 
 
  FormPtr frmP; 
 
  ShowControl(PanButton); 
  ShowControl(SelButton); 
  ShowControl(OrientButton); 
  ShowControl(PlaceButton); 
  ShowControl(CopyButton); 
  ShowControl(UndoButton); 
  ShowControl(DelButton); 
  ShowControl(WireButton); 
  ShowControl(BusButton); 
  ShowControl(JunButton); 
  ShowControl(SymButton); 
  ShowControl(ICButton); 
  ShowControl(GateButton); 
  ShowControl(LabelButton); 
  ShowControl(ElectButton); 
  ShowControl(OrthoButton); 
  ShowControl(GridButton); 
 
  frmP = FrmGetActiveForm(); 
  FrmDrawForm (frmP); 
 
} 
 
void MsgWin(char *msg) 
{ 
 
  RectanglePtr rPtr; 
 
  rPtr=MemPtrNew(sizeof(RectangleType)); 
 
  RctSetRectangle(rPtr,40,60,80,32); 
  WinEraseRectangle(rPtr,0); 
  WinDrawRectangleFrame(1,rPtr); 
  RctSetRectangle(rPtr,43,63,74,26); 
  WinDrawRectangleFrame(2,rPtr); 
  WinDrawChars(msg,StrLen(msg),52,73); 
  MemPtrFree(rPtr); 
 
} 
 
int GetFilename(char *buffer)  
{ 
 
  int f=0, r; 
  char *pFname; 
  WinHandle mainH; 
  FormPtr frmP, frm2P;  
 
  frmP = FrmGetActiveForm();  
  frm2P=FrmInitForm(FileEntryForm); 
  FrmSetActiveForm(frm2P); 
  SetTextToObject(RenameField,buffer); 
  r=FrmDoDialog(frm2P); 
 
  if(r==OKButton) { 
    pFname=GetTextFromObject(RenameField); 
    StrCopy(buffer,pFname); f=1; 
  } 
 
  FrmSetActiveForm(frmP); 
  FrmDeleteForm(frm2P); 
  FrmDrawForm(frmP); 
 
  DisplaySheet(SheetHandle,SheetX,SheetY,grid); 
 
  return f; 
 
} 
 
int SelectFile(char *buffer) 
{ 
 
  int f=0, r; 
  char *pName; 
  WinHandle mainH; 
  FormPtr frmP, frm2P;  
 
  frmP=FrmGetActiveForm(); 
 
  // process list form 
  frm2P=FrmInitForm(FileSelectForm); 
  FrmSetActiveForm(frm2P); 
  MakeFileList(FileList,'pDft','dsch',".sch"); 
  r=FrmDoDialog(frm2P); 
 
  // get list selection 
  pName=GetListItem(FileList); 
 
  if(r==FOKButton) { 
    StrCopy(buffer,pName);  
    f=1; 
  } 
 
  DiscardFileList(); 
  FrmSetActiveForm(frmP); 
  FrmDeleteForm(frm2P); 
  FrmDrawForm(frmP); 
 
  DisplaySheet(SheetHandle,SheetX,SheetY,grid); 
 
  return f; 
 
} 
 
void SaveBitmap(WinHandle wH) 
{ 
 
  UInt n; 
  VoidPtr p,pData; 
  VoidHand hnd; 
  WinPtr pWin; 
  DmOpenRef db; 
  LocalID id; 
 
  pWin=((WinPtr)wH); 
  pData=pWin->displayAddrV20; 
 
  if(Zoom!=ZOOM1) { 
    Zoom=ZOOM1; 
    DrawSheet(SheetHandle); 
    DisplaySheet(SheetHandle,SheetX,SheetY,grid); 
  } 
 
  MsgWin("Saving bitmap"); 
  db = NewDB("PDBITMAP",appFileCreator,'data'); 
  SetVersion(FileName,dataVersion); 
 
  // add new record to DB 
  hnd=DmNewRecord(db,&n,64500); 
  p=MemHandleLock(hnd); 
  DmWrite(p,0,pData,64000); 
  MemHandleUnlock(hnd); 
  DmReleaseRecord(db,n,true); 
  DmCloseDatabase(db); 
 
  DisplaySheet(SheetHandle,SheetX,SheetY,grid);      
   
} 
 
void PlaceObject(int flip) 
{ 
  DrawComponent(DRAWBG,SheetHandle,placeID,flip,placeN,placeX*Zoom,placeY*Zoom); 
  DrawComponent(DRAWFG,SheetHandle,placeID,flip,placeN,placeX,placeY); 
 
  if(placeID==LIBID)  
    WriteSchDB(SCHdb,-1,C_USERLIB,0,flip,placeN, 
      placeX*Zoom,placeY*Zoom,placeW,placeH); 
    else { 
      GetBitmapSize(placeID,&placeW,&placeH); 
      WriteSchDB(SCHdb,-1,C_BITMAP,placeID,0,"bmp", 
        placeX*Zoom,placeY*Zoom,placeW,placeH); 
    } 
 
} 
 
UInt MakeSymList(UInt ListID,char *mask) 
{ 
 
  UInt i, f, len, lbnum=0, offset=0; 
  MEMODB *pMemo; 
  DOCFILE *pD; 
  VoidHand h; 
  ListPtr l; 
 
  ItemsBuffer2 = MemPtrNew(3000);   
 
  // check within DOC lib 
  if(DmFindDatabase(0,LIBFILE)!=0) { 
    pD=OpenDoc(LIBFILE); 
   
    while(ReadDocLine(pD)) { 
      len=StrLen(pD->buffer)-1; 
      if(len<2) continue; 
   
      if(StrLen(mask)==0||StrStr(pD->buffer,mask)) { 
        for(i=0;i<len;i++)  
          ItemsBuffer2[offset+i] = pD->buffer[i]; 
 
        offset+=len;if(offset>2900) break; 
        ItemsBuffer2[offset++]=0;lbnum++;  
      } 
    } 
    CloseDoc(pD); 
  } 
 
 
  // now check within memos 
  f=0; pMemo = OpenMemo(); 
 
  while(SelectMemo(pMemo,f++)) { 
    ReadMemoLine(pMemo); 
    len=StrLen(pMemo->buffer)-1; 
    if(len<2) continue; 
   
    if(StrLen(mask)==0||StrStr(pMemo->buffer,mask)) { 
      for(i=0;i<len;i++)  
        ItemsBuffer2[offset+i] = pMemo->buffer[i]; 
 
      offset+=len;if(offset>2900) break; 
      ItemsBuffer2[offset++]=0;lbnum++;  
    } 
  } 
 
  CloseMemo(pMemo); 
 
  if(lbnum) { 
    l=GetObjectPtr(ListID); 
    h=SysFormPointerArrayToStrings(ItemsBuffer2,lbnum); 
    LstSetListChoices(l,MemHandleLock(h),lbnum); 
    LstSetSelection(l,0); 
    LstMakeItemVisible(l,0); 
    MemHandleUnlock(h); 
  } 
 
  return lbnum; 
 
} 
 
 
// ------------------------------------  
//          FILE FUNCTIONS 
// ------------------------------------ 
 
void CreateSample(void) 
{ 
  return; // discarded for OS5 
 
  int i=0; 
  MEMODB *pM; 
  char buffer[80]; 
 
  if(DmFindDatabase(0,LIBFILE)!=0) return; 
 
  pM=FindMemo("[IC]"); 
 
  if(pM) {  
    CloseMemo(pM); 
    return; 
  } 
 
  pM=OpenMemo(); 
  NewMemo(pM,1000); 
 
  while(GetSysString(SampleStr,i++,buffer)){ 
    WriteMemo(pM,buffer); 
    WriteMemo(pM,"\n"); 
  } 
  
  CloseMemo(pM); 
 
} 
 
int WriteSchDB(DmOpenRef db, int index, int type, int id, 
               int flip, char *label, int x, int y, int w, int h) 
{ 
 
  UInt n,i; 
  int len; 
  VoidHand hnd; 
  VoidPtr p; 
  SCHDB *pSch; 
 
  n=DmNumRecords(db); 
 
  if(index!=-1) n=index; 
  pSch = MemPtrNew(sizeof(SCHDB)); 
  pSch->id=id; 
  pSch->type=type; 
  pSch->flip=flip; 
  pSch->x=x; 
  pSch->y=y; 
  pSch->w=w; 
  pSch->h=h; 
  StrCopy(pSch->label,label); 
  len=(StrLen(label))-60; 
  len=sizeof(SCHDB) + len; len++; 
  if(len>sizeof(SCHDB)) len=sizeof(SCHDB); 
  
  // add new record to DB 
  hnd=DmNewRecord(db,&n,len); 
  p=MemHandleLock(hnd); 
  DmWrite(p,0,pSch,len); 
  MemHandleUnlock(hnd); 
  DmReleaseRecord(db,n,true); 
  MemPtrFree(pSch); 
 
  return false; 
 
} 
 
void Convert(DmOpenRef db) 
{ 
 
  int i,n,size; 
  VoidHand h; 
  OLDSCHDB *pOld; 
  SCHDB *pNew; 
 
  MsgWin("Converting..."); 
 
  SetVersion(FileName,dataVersion); 
  n=DmNumRecords(db); 
  if(n==0) return; 
 
  for(i=0;i<=n;i++) { 
 
    h = DmQueryRecord(db,i); 
    if(!h) return; 
    size = MemHandleSize(h); 
    if(!size) return; 
 
    pOld = MemHandleLock(h); 
 
    pNew->id=pOld->id; 
    pNew->type=pOld->type; 
    pNew->flip=(int)pOld->flip; 
    pNew->x=pOld->x; 
    pNew->y=pOld->y; 
    pNew->w=pOld->w; 
    pNew->h=pOld->h; 
    StrCopy(pNew->label,pOld->label); 
 
    MemHandleUnlock(h); 
 
    // Update record 
    DmRemoveRecord(db,i); 
    WriteSchDB(db,i,pNew->type,pNew->id, 
      pNew->flip,pNew->label,pNew->x,pNew->y, 
      pNew->w,pNew->h); 
  } 
} 
 
int ReadSchDB(DmOpenRef db,int index,SCHDB *pSch) 
{ 
 
  int i,n,size; 
  VoidHand h; 
  SCHDB *pDb; 
 
  n = DmNumRecords(db); 
  if(n==0||index>=n) return false; 
 
  h = DmQueryRecord(db,index); 
  if(!h) return false; 
  size = MemHandleSize(h); 
  if(!size) return false; 
 
  pDb = MemHandleLock(h); 
 
  pSch->id=pDb->id; 
  pSch->type=pDb->type; 
  pSch->flip=pDb->flip; 
  pSch->x=pDb->x; 
  pSch->y=pDb->y; 
  pSch->w=pDb->w; 
  pSch->h=pDb->h; 
  StrCopy(pSch->label,pDb->label); 
 
  MemHandleUnlock(h); 
  return true; 
 
} 
 
int WriteBlock(DmOpenRef Sdb,DmOpenRef Ddb, int mode, int destX, int destY, int x,int y,int x2,int y2) 
{ 
 
  int n,f,fx,fy; 
  SCHDB *pSch; 
 
  if(destX==-1||destY==-1) return 0; 
  if(x2-x==0 && y2-y==0) return 0; 
 
  MsgWin("Please wait..."); 
 
  pSch = MemPtrNew(sizeof(SCHDB)); 
  n=DmNumRecords(Sdb); 
 
  // check records for a match... 
  for(f=0;f<=n;f++) { 
    if(!ReadSchDB(Sdb,f,pSch))  
      continue; 
 
    fx=pSch->x; fy=pSch->y; 
 
    if(fx>x&&fx<x2&&fy>y&&fy<y2) { 
      if(pSch->type==C_WIRE||pSch->type==C_BUS) { 
        pSch->w=destX+(pSch->w-x); 
        pSch->h=destY+(pSch->h-y); 
      } 
      pSch->x=destX+(fx-x);  
      pSch->y=destY+(fy-y); 
 
      if(mode==MOVEBLOCK) { 
        DmRemoveRecord(Sdb,f); 
        WriteSchDB(Ddb,f,pSch->type,pSch->id, 
          pSch->flip,pSch->label,pSch->x,pSch->y, 
          pSch->w,pSch->h); 
      } 
      else if(mode==COPYBLOCK) { 
        WriteSchDB(Ddb,-1,pSch->type,pSch->id, 
          pSch->flip,pSch->label,pSch->x,pSch->y, 
          pSch->w,pSch->h); 
      } 
      else if(mode==DELBLOCK) { 
        DmRemoveRecord(Sdb,f); 
        f--;n--; 
      } 
    } 
  
  } 
 
  DrawSheet(SheetHandle); 
  DisplaySheet(SheetHandle,SheetX,SheetY,grid);      
  MemPtrFree(pSch); 
 
} 
 
 
void ExportBlock(void)  
{ 
 
  int x,y,x2,y2; 
  char fname[40]; 
  DmOpenRef expdb; 
 
  if(EditMode!=SELMODE) { 
    SndPlaySystemSound(1); 
    return; 
  } 
 
  StrCopy(fname,"export.sch"); 
  if(GetFilename(fname)==0) return; 
 
  expdb = NewDB(fname,appFileCreator,'dsch'); 
  if(expdb==NULL) return; 
  SetVersion(FileName,dataVersion); 
   
  x=(SheetX+RegionX)*Zoom; 
  y=(SheetY+RegionY)*Zoom; 
  x2=x+(RegionX2*Zoom); 
  y2=y+(RegionY2*Zoom); 
  TargetX=0; TargetY=0; 
 
  WriteBlock(SCHdb,expdb,COPYBLOCK,TargetX,  
    TargetY,x,y,x2,y2); 
 
  CloseDB(expdb); 
 
} 
 
void ImportBlock(void) 
{ 
 
  int x,y; 
  char fname[40]; 
  DmOpenRef impdb; 
 
  if(EditMode!=SELMODE) { 
    SndPlaySystemSound(1); 
    return; 
  } 
 
  if(SelectFile(fname)==0) return; 
  impdb = OpenDB(fname); 
 
  x=(SheetX+RegionX)*Zoom; 
  y=(SheetY+RegionY)*Zoom; 
 
  WriteBlock(impdb,SCHdb,COPYBLOCK,x,y,0,0,800,640); 
 
  CloseDB(impdb); 
  
} 
 
 
// ------------------------------------  
//        DRAW LIBRARY COMPONENT 
// ------------------------------------ 
 
int DrawSymbol(int id,int win,WinHandle workH,int x,int y) 
{ 
 
  int r,w=0,h=0; 
  WinHandle mainH; 
  RectanglePtr rPtr; 
 
  rPtr=MemPtrNew(sizeof(RectangleType)); 
  mainH=WinGetActiveWindow(); 
 
  if(win==DRAWBG) { 
    x=(x/Zoom);  y=(y/Zoom); 
      
    WinSetDrawWindow(workH); 
 
    if(Zoom>ZOOM1) { 
      GetBitmapSize(id,&w,&h); 
      RctSetRectangle(rPtr,x+1,y+1,w/Zoom,h/Zoom); 
      WinDrawRectangle(rPtr,1); 
    } 
    else r=DrawBitmap(id,x,y); 
    WinSetDrawWindow(mainH); 
  } 
 
  else { 
    x=x-SheetX; y=y-SheetY; 
    RctSetRectangle(rPtr,0,0,160,148); 
    WinSetClip(rPtr); 
    r=DrawBitmap(id,x,y); 
    RctSetRectangle(rPtr,0,0,160,160); 
    WinSetClip(rPtr); 
  } 
        
  MemPtrFree(rPtr); 
  return r; 
 
} 
 
DOCFILE *FindDoc(char *title) 
{ 
 
  DOCFILE *pD; 
 
  if(DmFindDatabase(0,LIBFILE)==0) 
    return NULL; 
 
  pD=OpenDoc(LIBFILE); 
   
  while(ReadDocLine(pD)) { 
    if(StrStr(pD->buffer,title)) { 
      return pD; 
 	} 
  } 
 
  CloseDoc(pD); 
  return NULL; 
 
} 
 
int ReadLine(DOCFILE *pD,MEMODB *pM,char *buffer) 
{ 
 
  int r=0; 
 
  // read from DOC 
  if(pD!=NULL) { 
    r=ReadDocLine(pD); 
    if(StrStr(pD->buffer,"[IC]")) 
       return 0; 
    StrCopy(buffer,pD->buffer); 
    return r; 
  } 
 
  // read from memo 
  if(pM!=NULL) { 
    r=ReadMemoLine(pM); 
    StrCopy(buffer,pM->buffer); 
    return r; 
  } 
 
} 
 
int DrawComponent(int win,WinHandle workH, int id, int flip, char *title, int x, int y) 
{ 
 
  MEMODB *pM; 
  DOCFILE *pD; 
 
  char PartNo[20], pino[20]; 
  RectanglePtr rPtr; 
  char buffer[100]; 
 
  WinHandle mainH; 
  int r,w,h,pinlen,dlen,plen,z; 
  int lpos,rpos; 
  char bp,pol,dir,*pS,*desc; 
 
  if(id>LIBID) return DrawSymbol(id,win,workH,x,y); 
  mainH=WinGetActiveWindow(); 
 
  pinlen=16; 
  pD=NULL; 
  pM=NULL; 
 
  pD=FindDoc(title); 
 
  if(pD==NULL) { 
    pM=FindMemo(title); 
    if(pM==NULL) return 0; 
    StrCopy(buffer,pM->buffer); 
  } 
  else StrCopy(buffer,pD->buffer); 
 
  rPtr=MemPtrNew(sizeof(RectangleType)); 
 
  pinlen=pinlen/Zoom; 
 
  if(win==DRAWBG) { 
    x=(x/Zoom)+pinlen+1;  
    y=(y/Zoom)+1; 
    WinSetDrawWindow(workH); 
  } 
 
  if(win==DRAWFG) { 
    x=x-SheetX+pinlen+1; y=y-SheetY+1; 
    RctSetRectangle(rPtr,0,0,160,148); 
    WinSetClip(rPtr); 
  } 
  
  z=8/Zoom; 
 
  // Get part no 
  pS=&buffer[4]; 
  StrCopy(PartNo,pS); 
  StripLF(PartNo); 
 
  // get width 
  ReadLine(pD,pM,buffer); 
  w=(int)StrAToI(buffer); 
  placeW=w*8; 
  w=(placeW/Zoom)-1; 
 
  // get height 
  ReadLine(pD,pM,buffer); 
  h=(int)StrAToI(buffer); 
  placeH=h*8; 
  h=(placeH/Zoom)-1; 
 
  lpos=y+z-1; rpos=y+z-1; 
 
  // get pinouts 
  while(ReadLine(pD,pM,buffer)) { 
 
    // read values 
    StripLF(buffer); 
    pol=buffer[StrLen(buffer)-1]; 
    if(pol=='-') buffer[StrLen(buffer)-1]=0; 
 
    bp=buffer[0]; 
    dir=buffer[3]; 
    buffer[3]=0; 
 
    StrCopy(pino,buffer); 
    desc=&buffer[4]; 
    plen=StrLen(pino); 
    dlen=StrLen(desc); 
 
    if(flip) { 
      if(dir=='<') dir='>'; 
      else if(dir=='>') dir='<'; 
    } 
 
    // draw left side pins 
    if(dir=='<') { 
      if(bp!='-') { 
        WinDrawLine(x-pinlen-1,lpos,x-1,lpos); 
 
        if(Zoom==ZOOM1) { 
          WinDrawChars(desc,dlen,x+2,lpos-2); 
          if(pol=='-') WinDrawLine(x+2,lpos-3,x+(dlen*4),lpos-3); 
          WinDrawChars(pino,plen,x-(plen*4)-1,lpos-6); 
        } 
        if(Zoom==ZOOM2) { 
          WinDrawLine(x+1,lpos-1,x+(dlen*2),lpos-1); 
          WinDrawLine(x+1,lpos,x+(dlen*2),lpos); 
        } 
        if(Zoom==ZOOM4) WinDrawLine(x+1,lpos,x+1+dlen-1,lpos); 
 
      } 
      lpos=lpos+z; 
    } 
 
    // draw right side pins 
    if(dir=='>') { 
      if(bp!='-') { 
        WinDrawLine(x+w,rpos,x+w+pinlen,rpos); 
 
        if(Zoom==ZOOM1) { 
          WinDrawChars(desc,dlen,x+w-(dlen*4)-1,rpos-2); 
          if(pol=='-') WinDrawLine(x+w-(dlen*4)-1,rpos-3,x+w-2,rpos-3); 
          WinDrawChars(pino,plen,x+w+2,rpos-6); 
        } 
        if(Zoom==ZOOM2) { 
          WinDrawLine(x+w-(dlen*2)-1,rpos-1,x+w-2,rpos-1); 
          WinDrawLine(x+w-(dlen*2)-1,rpos,x+w-2,rpos); 
        } 
        if(Zoom==ZOOM4) WinDrawLine(x+w-dlen-1,rpos,x+w-2,rpos); 
 
      } 
      rpos=rpos+z; 
    } 
     
  } 
 
  // Draw component frame + partno 
  RctSetRectangle(rPtr,x,y,w,h); 
  WinDrawRectangleFrame(1,rPtr); 
 
  if(Zoom==ZOOM1) { 
    RctSetRectangle(rPtr,x+1,y+1,w-2,h-2); 
    WinDrawRectangleFrame(1,rPtr); 
  } 
 
  if(Zoom==ZOOM1) WinDrawChars(PartNo,StrLen(PartNo),x,y-7); 
  if(Zoom==ZOOM2) { 
    WinDrawLine(x,y-4,x+(StrLen(PartNo)*2),y-4); 
    WinDrawLine(x,y-3,x+(StrLen(PartNo)*2),y-3); 
  }  
  if(Zoom==ZOOM4) WinDrawLine(x,y-2,x+StrLen(PartNo)-1,y-2); 
 
  if(win==DRAWFG) { 
    RctSetRectangle(rPtr,0,0,160,160); 
    WinSetClip(rPtr); 
  } 
        
  MemPtrFree(rPtr); 
  WinSetDrawWindow(mainH); 
 
  if(pD==NULL) CloseMemo(pM); 
  if(pD!=NULL) CloseDoc(pD); 
 
  return 1; 
 
} 
 
 
// ------------------------------------  
//          SHEET FUNCTIONS 
// ------------------------------------ 
 
WinHandle CreateSheet(Word w, Word h) 
 
{ 
 
  WinHandle workH,mainH;  
  Word error=0; 
  
  // main window (OS5=hires) 
  if(OS5&&ColorSupport()) {
     mainB=BmpCreate(160,160,1,NULL,&error); 
     mainV3=BmpCreateBitmapV3(mainB,kDensityDouble,BmpGetBits(mainB),NULL); 
     mainH=WinCreateBitmapWindow((BitmapType*)mainV3,&error); 
   }
   else  mainH=WinGetActiveWindow(); 
   
    //background window (lores) 
    if(ColorSupport()) { 
      workB=BmpCreate(w,h,1,NULL,&error); 
      if(OS5&&ColorSupport()) { 
        workV3=BmpCreateBitmapV3(workB,kDensityLow,BmpGetBits(workB),NULL);     
        workH=WinCreateBitmapWindow((BitmapType*)workV3,&error); 
      } 
      else workH=WinCreateBitmapWindow(workB,&error); 
    } 
    else workH=WinCreateOffscreenWindow(w,h,genericFormat,&error); 
     
  WinSetDrawWindow(workH); 
  WinEraseWindow(); 
  WinSetDrawWindow(mainH); 
 
  return workH; 
 
} 
 
void DisplaySheet(WinHandle workH, Word originX, Word originY,int grid) 
 
{ 
 
  int i,k,w,h; 
  WinHandle mainH; 
  RectanglePtr rPtr; 
  EventType evt; 
  Err err; 
   
  w=((SheetW/Zoom)-(SheetX));  
  if(w>160) w=160; 
  h=((SheetH/Zoom)-(SheetY)); 
  if(h>148) h=148; 
 
  mainH=WinGetActiveWindow(); 
 
  EvtGetEvent(&evt,0); 
  SysHandleEvent(&evt); 
 
  rPtr=MemPtrNew(sizeof(RectangleType)); 
 
 if(OS5&&HiZoom) { 
    RctSetRectangle(rPtr,originX,originY,160,160); 
  } 
 else RctSetRectangle(rPtr,originX,originY,160,148); 
   
  // set offscreen to hi density 
  if(HiRes&&HiZoom) { 
	  BmpSetDensity((BitmapType*) workV3,kDensityDouble); 
	  workH=WinCreateBitmapWindow((BitmapType*)workV3,&err); 
  } 
  // copy to main screen 
 WinCopyRectangle(workH,mainH,rPtr,0,0,scrCopy); 
 
  // draw grid 
  if(grid&&HiZoom==0) { 
    for(i=0;i<h;i+=grid)  
      for(k=0;k<w;k+=grid) 
        WinDrawLine(k,i,k,i); 
  } 
   
// set back to lo density 
 if(HiRes&&HiZoom) { 
   BmpSetDensity((BitmapType*) workV3,kDensityLow); 
   workH=WinCreateBitmapWindow((BitmapType*)workV3,&err); 
} 
  MemPtrFree(rPtr); 
 
} 
 
void DrawSheet(WinHandle workH) 
{ 
 
  WinHandle mainH; 
  RectanglePtr rPtr; 
  int n,w,h; 
  int f=0,k; 
  SCHDB *pSch; 
  FormPtr frmP; 
  EventType evt; 
 
  if(ColorSupport()) ZoomLimit=0; 
  if(GetVersion(FileName)==0) Convert(SCHdb); 
  rPtr=MemPtrNew(sizeof(RectangleType)); 
  pSch = MemPtrNew(sizeof(SCHDB)); 
  n=DmNumRecords(SCHdb); 
 
  if(n>ZoomLimit) MsgWin("Please wait..."); 
  mainH=WinGetActiveWindow(); 
 
  WinSetDrawWindow(workH); 
  w=SheetW/Zoom;  
  h=SheetH/Zoom; 
  WinEraseWindow(); 
 
  // Window frame 
  RctSetRectangle(rPtr,1,1,w-2,h-2); 
  if(HiZoom==0) WinDrawRectangleFrame(1,rPtr);         
 
  // Load schematic... 
  for(f=0;f<=n;f++) { 
    if(!ReadSchDB(SCHdb,f,pSch))  
      continue; 
    WinSetDrawWindow(workH); 
    
    switch(pSch->type) { 
 
      case C_WIRE: 
           WinDrawLine(pSch->x/Zoom, 
           pSch->y/Zoom, 
           pSch->w/Zoom, 
           pSch->h/Zoom); 
       	 break; 
 
      case C_BUS: 
      	 WinDrawLine((pSch->x-1)/Zoom, 
      	 (pSch->y-1)/Zoom, 
      	 (pSch->w-1)/Zoom, 
      	 (pSch->h-1)/Zoom); 
 
      	 WinDrawLine(pSch->x/Zoom, 
     	 pSch->y/Zoom, 
      	 pSch->w/Zoom, 
      	 pSch->h/Zoom); 
 
     	 WinDrawLine((pSch->x+1)/Zoom, 
     	 (pSch->y+1)/Zoom, 
     	 (pSch->w+1)/Zoom, 
      	 (pSch->h+1)/Zoom); 
		 break; 
 
      case C_JUNCTION: 
     	 if(Zoom==ZOOM1) { 
             RctSetRectangle(rPtr,pSch->x/Zoom, 
     	     pSch->y/Zoom, 
     	     pSch->w/Zoom, 
     	     pSch->h/Zoom); 
               WinDrawRectangle(rPtr,0);  
           } 
		 break; 
 
      case C_LABEL: 
     	 if(Zoom==ZOOM1)  
       	   WinDrawChars(pSch->label,pSch->w/4, 
               pSch->x,pSch->y); 
           else { 
             RctSetRectangle(rPtr,pSch->x/Zoom,pSch->y/Zoom, 
               pSch->w/Zoom,pSch->h/Zoom); 
             WinDrawRectangle(rPtr,1); 
           } 
           break; 
 
    	 case C_BITMAP: 
      	 DrawSymbol(pSch->id,DRAWBG,workH,  
             pSch->x, pSch->y); 
           break; 
 
      case C_USERLIB: 
      	 DrawComponent(DRAWBG,workH,0,pSch->flip,pSch->label,  
             pSch->x, pSch->y); 
           break; 
    } 
 
   if(n<=ZoomLimit) { 
      WinSetDrawWindow(mainH); 
      DisplaySheet(SheetHandle,SheetX,SheetY,0); 
    }     
    
  } 
 
  WinSetDrawWindow(mainH); 
  frmP=FrmGetActiveForm(); 
  FrmDrawForm(frmP); 
 
  DisplaySheet(SheetHandle,SheetX,SheetY,grid); 
 
  MemPtrFree(rPtr); 
  MemPtrFree(pSch); 
 
} 
 
 
int PanSheet(WinHandle workH,int slide, int scroll, int *origX, int *origY) 
{ 
 
  WinHandle mainH; 
  int fx=0,fy=0,tx,ty,xd,yd,oX=0,oY=0; 
  int sheetW,sheetH; 
  Boolean t=0,d=0; 
 
  oX=*origX; oY=*origY; 
 
  sheetW=SheetW/Zoom; 
  sheetH=SheetH/Zoom; 
  if(ColorSupport()) scroll=scroll*2; 
 
  EvtGetPen(&fx,&fy,&t); 
 
  while(t&fy>0&fy<148) { 
    EvtGetPen(&tx,&ty,&t); 
    if(!t) break; 
 
    if(tx>fx) xd=tx-fx; else xd=fx-tx; 
    if(ty>fy) yd=ty-fy; else yd=fy-ty; 
 
    if(xd>slide&&tx<fx) { 
      oX+=scroll; fx=tx; 
      if(oX+160>sheetW) oX=sheetW-160; 
      DisplaySheet(workH,oX,oY,0);d=1; 
    } 
         
    if(xd>slide&&tx>fx) { 
      oX-=scroll; fx=tx;  
      if(oX<0) oX=0; 
      DisplaySheet(workH,oX,oY,0);d=1; 
    } 
 
    if(yd>slide&&ty<fy) { 
      oY+=scroll; fy=ty; 
      if(oY+148>sheetH) oY=sheetH-148; 
      DisplaySheet(workH,oX,oY,0);d=1; 
    } 
         
    if(yd>slide&&ty>fy) { 
      oY-=scroll; fy=ty;  
      if(oY<0) oY=0; 
      DisplaySheet(workH,oX,oY,0);d=1; 
    } 
  } 
 
  *origX=oX; *origY=oY; 
  if(d) DisplaySheet(workH,oX,oY,grid); 
  return d; 
} 
 
 
// ------------------------------------  
//           SELECT REGION 
// ------------------------------------ 
 
int SelectRegion(void) 
{ 
 
  int x,y,fx,fy,tx,ty,xd,yd; 
  int rx,ry,ow,oh; 
  int snap=4; 
 
  char buf[20]; 
  Boolean t; 
  WinHandle mainH; 
  RectanglePtr rPtr; 
 
  rPtr=MemPtrNew(sizeof(RectangleType)); 
 
  // set clip 
  RctSetRectangle(rPtr,0,0,160,148); 
  WinSetClip(rPtr); 
 
  // get starting pos 
  EvtGetPen(&fx,&fy,&t); 
  fx=fx/snap*snap; fy=fy/snap*snap; 
  tx=fx;ty=fy;x=tx;y=ty;xd=1;yd=1; 
 
  while(t&&fy>0&fy<150) { 
 
    rx=fx; ry=fy; 
    if(tx<fx) rx=tx; if(ty<fy) ry=ty; 
    RctSetRectangle(rPtr,rx+1,ry+1,xd-1,yd-1); 
    WinInvertRectangleFrame(1,rPtr); 
 
    ow=xd;oh=yd;x=tx;y=ty; 
 
    do { 
      EvtGetPen(&tx,&ty,&t); 
      tx=tx/snap*snap; ty=ty/snap*snap; 
      if(tx>fx) xd=tx-fx; else xd=fx-tx; 
      if(ty>fy) yd=ty-fy; else yd=fy-ty; 
    } while(t&&x==tx&&y==ty); 
 
    // erase previous line 
    RctSetRectangle(rPtr,rx+1,ry+1,ow-1,oh-1); 
    WinInvertRectangleFrame(1,rPtr); 
 
  } 
  
  if(ty>0&&ty<150) { 
 
    // clear previous selection 
    RctSetRectangle(rPtr,RegionX,RegionY,RegionX2,RegionY2); 
    WinInvertRectangle(rPtr,0); 
 
    if(xd>4&&yd>4) { 
      RctSetRectangle(rPtr,rx,ry,ow+1,oh+1); 
      WinInvertRectangle(rPtr,0); 
      RegionX=rx; RegionY=ry;  
      RegionX2=ow+1;RegionY2=oh+1; 
    } 
    else { 
      TargetX=tx; TargetY=ty; 
      RctSetRectangle(rPtr,tx,ty,RegionX2,RegionY2); 
      WinInvertRectangle(rPtr,0); 
    } 
  } 
 
  // reset clip 
  RctSetRectangle(rPtr,0,0,160,160); 
  WinSetClip(rPtr); 
  MemPtrFree(rPtr); 
 
} 
 
 
// ------------------------------------  
//             GET COMPONENT 
// ------------------------------------ 
 
int GetBasic(int bmpID) 
{ 
 
  int id=0, x,y,t=0; 
  RectanglePtr rPtr; 
  EventType evt; 
 
  int sID[56]= { 
    2010,2000,2020,2030,2040,2050,2060,2070, 
    2080,2090,2100,2110,2120,2130,2140,2240,   
    2150,2160,2250,2260,2290,2300,2170,2330, 
    2310,2320,2315,2325,2340,2350,2345,2355, 
    2360,2370,2365,2375,2180,2190,2200,2210, 
    2220,2230,2235,2400,2410,3000,3050,3040, 
    3010,3020,3030,3060,2500,2510,3100,0000 
  }; 
 
  int gID[56]= { 
    4000,4010,4020,4030,4040,4050,4060,4070, 
    5000,5005,5010,4200,4210,0000,0000,0000,   
    4100,4300,0000,0000,0000,0000,0000,0000, 
    0000,0000,0000,0000,0000,0000,0000,0000, 
    4500,4510,4520,4530,4540,4550,4560,4570, 
    4580,4590,4600,4610,4620,4690,4680,4700, 
    4630,4640,4650,4660,4670,4635,0000,0000 
  }; 
 
  DrawBitmap(bmpID,0,0); 
  WinDrawChars("Please select a symbol to place",31,15,143); 
 
  EvtGetPen(&x,&y,&t); 
 
  while(1){  
    EvtGetPen(&x,&y,&t); 
    if(t>0&&y<144) break; 
    EvtGetEvent(&evt,0); 
    SysHandleEvent(&evt); 
  } 
 
  x=x/20; y=y/20; 
  id=(y*8)+x;  
  if(bmpID==SYMBMP) id=sID[id]; 
  if(bmpID==GATEBMP) id=gID[id]; 
 
  x=x*20; y=y*20; 
 
  rPtr=MemPtrNew(sizeof(RectangleType)); 
  RctSetRectangle(rPtr,x+1,y+1,19,19); 
  WinInvertRectangle(rPtr,1); 
  MemPtrFree(rPtr);  
 
  EvtGetPen(&x,&y,&t); 
  while(t) EvtGetPen(&x,&y,&t); 
 
  DisplaySheet(SheetHandle,SheetX,SheetY,grid); 
 
  baseID=id; 
  if(!id) placeID=0; 
  return id; 
   
} 
 
int GetSymbol(UInt strID) 
{ 
  int i,r; 
  char *pT; 
  WinHandle mainH; 
  FormPtr frmP, frm2P;  
 
  if(strID==SymbolList)  
    return GetBasic(SYMBMP); 
 
  if(strID==GateList)  
    return GetBasic(GATEBMP); 
 
  // close main form 
  mainH=WinGetActiveWindow(); 
  frmP=FrmGetActiveForm(); 
  FrmEraseForm(frmP); 
 
  // process list form 
  frm2P=FrmInitForm(FileSelectForm); 
  FrmSetActiveForm(frm2P); 
  MakeStrList(FileList,strID); 
 
  r=FrmDoDialog(frm2P); 
 
  // get list selection 
  pT=GetListItem(FileList); 
 
  // back to main form 
  FrmSetActiveForm(frmP); 
  FrmDrawForm(frmP); 
  FrmDeleteForm(frm2P); 
  WinSetDrawWindow(mainH); 
 
  DisplaySheet(SheetHandle,SheetX,SheetY,grid); 
 
  if(r==FOKButton) { 
    pT[4]=0; 
    i=StrAToI(pT); 
    if(i<2000) i=2000; 
    DiscardFileList(); 
    baseID=i; 
    return i; 
  } 
 
  DiscardFileList(); 
  return 0; 
 
} 
 
 
int GetLibComponent(char *s) 
{ 
 
  int i,r; 
  ListPtr l; 
  char *pT; 
  WinHandle mainH; 
  FormPtr frmP, frm2P;  
 
  // close main form 
  mainH=WinGetActiveWindow(); 
  frmP=FrmGetActiveForm(); 
  FrmEraseForm(frmP); 
 
  // process list form 
  frm2P=FrmInitForm(FileSelectForm); 
  FrmSetActiveForm(frm2P); 
  MakeSymList(FileList,"[IC]"); 
 
  r=FrmDoDialog(frm2P); 
 
  // get list selection 
  pT=GetListItem(FileList); 
  DiscardMemoList(); 
 
  // back to main form 
  FrmSetActiveForm(frmP); 
  FrmDrawForm(frmP); 
  FrmDeleteForm(frm2P); 
 
  WinSetDrawWindow(mainH); 
  DisplaySheet(SheetHandle,SheetX,SheetY,grid); 
 
  if(r==FOKButton) { 
    StrCopy(s,pT); 
    return 1; 
  } 
 
  s[0]=0; return 0; 
 
} 
 
// ------------------------------------  
//          ENTER WIRE/BUS 
// ------------------------------------ 
 
void EnterWire(WinHandle workH, int snap, int type) 
{ 
 
  int m,s,x,y,fx,fy,tx,ty,xd,yd; 
  int rx,ry,ow,oh; 
  char buf[20]; 
  Boolean t; 
  WinHandle mainH; 
  RectanglePtr rPtr; 
 
  snap=snap/Zoom; 
  rPtr=MemPtrNew(sizeof(RectangleType)); 
 
  // set clip 
  RctSetRectangle(rPtr,0,0,160,150); 
  WinSetClip(rPtr); 
 
  // get starting pos 
  EvtGetPen(&fx,&fy,&t); 
  fx=fx/snap*snap; fy=fy/snap*snap; 
  tx=fx;ty=fy;x=tx;y=ty;xd=1;yd=1; 
 
  while(t&&fy>0&fy<150) { 
 
    WinInvertLine(fx,fy,tx,ty); 
 
    if(type==THICKLINE) { 
      WinInvertLine(fx-1,fy-1,tx-1,ty-1); 
      WinInvertLine(fx+1,fy+1,tx+1,ty+1); 
    } 
 
    ow=xd;oh=yd;x=tx;y=ty; s=0; 
 
    do { 
      EvtGetPen(&tx,&ty,&t); 
      tx=tx/snap*snap; ty=ty/snap*snap; 
      if(tx>fx) xd=tx-fx; else xd=fx-tx; 
      if(ty>fy) yd=ty-fy; else yd=fy-ty; 
    } while(t&&x==tx&&y==ty); 
 
    // orthogonal correction 
    if(Ortho||type==THICKLINE)  
      if(xd<yd) tx=fx;  
    else ty=fy; 
 
    // erase previous line 
    WinInvertLine(fx,fy,x,y); 
 
    if(type==THICKLINE) { 
      WinDrawLine(fx-1,fy-1,tx-1,ty-1); 
      WinDrawLine(fx+1,fy+1,tx+1,ty+1); 
    } 
  } 
  
  if(ty>0&&ty<150) { 
    mainH=WinGetActiveWindow(); 
 
    m=C_WIRE; 
    WinDrawLine(fx,fy,x,y); 
 
    if(type==THICKLINE) { 
      WinDrawLine(fx-1,fy-1,tx-1,ty-1); 
      WinDrawLine(fx+1,fy+1,tx+1,ty+1); 
      m=C_BUS; 
    } 
 
    WinSetDrawWindow(workH); 
    WinDrawLine(SheetX+fx,SheetY+fy,SheetX+tx,SheetY+ty); 
 
    if(type==THICKLINE) { 
      WinDrawLine(SheetX+fx-1,SheetY+fy-1,SheetX+tx-1,SheetY+ty-1); 
      WinDrawLine(SheetX+fx+1,SheetY+fy+1,SheetX+tx+1,SheetY+ty+1); 
    } 
 
    WriteSchDB(SCHdb,-1,m,0,0,"", 
      (SheetX+fx)*Zoom, 
      (SheetY+fy)*Zoom, 
      (SheetX+tx)*Zoom, 
      (SheetY+ty)*Zoom); 
 
    WinSetDrawWindow(mainH); 
  } 
 
  // reset clip 
  RctSetRectangle(rPtr,0,0,160,160); 
  WinSetClip(rPtr); 
  MemPtrFree(rPtr); 
 
} 
 
// ------------------------------------  
//          ENTER JUNCTION 
// ------------------------------------ 
 
void EnterJunction(WinHandle workH, int snap) 
{ 
  int x,y,fx,fy,tx,ty,xd,yd; 
  int size=3,pos=1; 
  char buf[20]; 
  Boolean t; 
  WinHandle mainH; 
  RectanglePtr rPtr; 
 
  snap=snap/Zoom; 
  rPtr=MemPtrNew(sizeof(RectangleType)); 
 
  // set clip 
  RctSetRectangle(rPtr,0,0,160,150); 
  WinSetClip(rPtr); 
 
  EvtGetPen(&x,&y,&t); 
  x=x/snap*snap; y=y/snap*snap; 
  tx=x;ty=y; 
 
  while(t&y>0&y<150) { 
    RctSetRectangle(rPtr,tx-pos,ty-pos,size,size); 
    WinInvertRectangle(rPtr,0); 
 
    x=tx;y=ty; 
    do { 
      EvtGetPen(&tx,&ty,&t); 
      tx=tx/snap*snap; ty=ty/snap*snap; 
    } while(t&&x==tx&&y==ty); 
 
    RctSetRectangle(rPtr,x-pos,y-pos,size,size); 
    WinInvertRectangle(rPtr,0); 
 
  } 
     
  if(ty>0&&ty<144) { 
    WinDrawRectangle(rPtr,0); 
    mainH=WinGetActiveWindow(); 
 
    // draw into sheet 
    WinSetDrawWindow(workH); 
    RctSetRectangle(rPtr,SheetX+tx-pos,SheetY+ty-pos,size,size); 
    WinDrawRectangle(rPtr,0); 
 
    WriteSchDB(SCHdb,-1,C_JUNCTION,0,0,"", 
      (SheetX+tx-pos)*Zoom, 
      (SheetY+ty-pos)*Zoom, 
      size,size); 
 
    WinSetDrawWindow(mainH); 
  } 
 
  // reset clip 
  RctSetRectangle(rPtr,0,0,160,160); 
  WinSetClip(rPtr); 
  MemPtrFree(rPtr); 
 
} 
 
// ------------------------------------  
//             ENTER LABEL 
// ------------------------------------ 
 
void WriteLabel(WinHandle workH, char *s, int x, int y) 
{ 
 
  WinHandle mainH; 
 
  if(StrLen(s)==0) return; 
  if(StrLen(s)>58) s[58]=0; 
 
  mainH=WinGetActiveWindow(); 
  WinSetDrawWindow(workH); 
  WinDrawChars(s,StrLen(s),SheetX+x,SheetY+y); 
 
  WriteSchDB(SCHdb,-1,C_LABEL,0,0,s,SheetX+x,SheetY+y,StrLen(s)*4,4); 
  WinSetDrawWindow(mainH); 
 
} 
 
void EnterLabel(WinHandle workH, int snap) 
{ 
 
  int k,x,y,sx,cx,cy,kcount=0; 
  Boolean t; 
  WinHandle mainH; 
  FormPtr frmP; 
 
  EventType evt; 
  EventPtr evtP; 
  char s[100]; 
 
  evtP = &evt; 
 
  if(Zoom>ZOOM1) { 
    SndPlaySystemSound(1); 
    return; 
  } 
 
  frmP=FrmGetActiveForm(); 
  FrmSetActiveForm(frmP); 
  mainH=WinGetActiveWindow(); 
  WinSetActiveWindow(mainH); 
  WinSetDrawWindow(mainH); 
 
  EvtGetPen(&cx,&cy,&t);  
  sx=cx; s[0]=0; 
  cx=(cx/snap*snap)-1;  
  cy=(cy/snap*snap)-2; 
 
  InsPtSetLocation(cx,cy); 
  InsPtSetHeight(6); 
  InsPtEnable(1); 
  EvtGetEvent(&evt,0); 
  SysHandleEvent(&evt); 
 
  while(1) { 
    EvtGetEvent(&evt,0); 
    SysHandleEvent(&evt); 
    EvtGetPen(&x,&y,&t); 
 
    k=evtP->data.keyDown.chr; 
 
  if((k>255&&evtP->eType==keyDownEvent)||(y>148 && y<160)) { 
      InsPtEnable(0); 
      WriteLabel(workH,s,sx,cy); 
      break; 
    } 
 
    if(evtP->eType==keyDownEvent) { 
 
      // Enter (save & start new str) 
      if(k==10) { 
        if(StrLen(s)>0) WriteLabel(workH,s,sx,cy); 
        cy+=8; s[0]=0; kcount=0; 
      } 
 
      // backspace 
      if(k==8 && kcount) { 
        s[kcount-1]=32; 
        WinDrawChars(s,StrLen(s),sx,cy);  
        s[--kcount]=0; 
      } 
 
      if(k>31) s[kcount++]=k;  
 
      s[kcount]=0; 
      InsPtEnable(0); 
      WinDrawChars(s,StrLen(s),sx,cy);  
      cx=sx+(kcount*4); 
      InsPtSetLocation(cx,cy); 
      InsPtEnable(1); 
    } 
 
    // change cursor location 
    else  
    if(y<150&&evtP->eType==penDownEvent) { 
      if(StrLen(s)>0) { 
        WriteLabel(workH,s,sx,cy); 
        s[0]=0; 
      } 
      cx=(x/snap*snap)-1; cy=(y/snap*snap)-2; 
      InsPtSetLocation(cx,cy); 
      sx=cx; kcount=0; 
    } 
 
  } 
 
} 
 
// ------------------------------------  
//           REPEAT TRACE 
// ------------------------------------ 
 
void RepeatTrace(void) 
{ 
  SCHDB *pSch; 
  WinHandle mainH; 
  int r,x,y, LastRec; 
 
  
  pSch = MemPtrNew(sizeof(SCHDB)); 
  LastRec=DmNumRecords(SCHdb)-1; 
  if(LastRec>1) ReadSchDB(SCHdb,LastRec,pSch); 
 
  if(LastRec>1&&pSch->type==C_WIRE) { 
    if(pSch->x==pSch->w) { 
      pSch->x+=8; 
      pSch->w+=8; 
    } 
 
    if(pSch->y==pSch->h) { 
      pSch->y+=8; 
      pSch->h+=8; 
    } 
  
    mainH=WinGetActiveWindow(); 
    WinSetDrawWindow(SheetHandle); 
    WinDrawLine(pSch->x/Zoom, 
    pSch->y/Zoom, 
    pSch->w/Zoom, 
    pSch->h/Zoom); 
    WinSetDrawWindow(mainH); 
    DisplaySheet(SheetHandle,SheetX,SheetY,grid);      
 
    WriteSchDB(SCHdb,-1,pSch->type,pSch->id, 
      pSch->flip,pSch->label,pSch->x,pSch->y,pSch->w,pSch->h); 
    } 
 
    else SndPlaySystemSound(1); 
    MemPtrFree(pSch); 
} 
 
 
// ------------------------------------  
//            UNDO/DELETE 
// ------------------------------------ 
 
void EraseComponent(WinHandle workH,SCHDB *pSch) 
{ 
 
  WinHandle mainH; 
  RectanglePtr rPtr; 
 
  mainH=WinGetActiveWindow(); 
 
  rPtr=MemPtrNew(sizeof(RectangleType)); 
 
  switch(pSch->type) 
  { 
      case C_WIRE: 
           WinSetDrawWindow(workH); 
           WinEraseLine(pSch->x/Zoom, 
             pSch->y/Zoom, 
             pSch->w/Zoom, 
             pSch->h/Zoom); 
           WinSetDrawWindow(mainH); 
           break; 
 
      case C_BUS: 
           WinSetDrawWindow(workH); 
           WinEraseLine((pSch->x-1)/Zoom, 
             (pSch->y-1)/Zoom, 
             (pSch->w-1)/Zoom, 
             (pSch->h-1)/Zoom); 
 
           WinEraseLine(pSch->x/Zoom, 
             pSch->y/Zoom, 
             pSch->w/Zoom, 
             pSch->h/Zoom); 
 
           WinEraseLine((pSch->x+1)/Zoom, 
             (pSch->y+1)/Zoom, 
             (pSch->w+1)/Zoom, 
             (pSch->h+1)/Zoom); 
 
           WinSetDrawWindow(mainH); 
           break; 
 
      case C_USERLIB: 
           DrawSheet(SheetHandle); 
           break; 
 
      case C_BITMAP: 
      case C_LABEL: 
      case C_JUNCTION:  
 
           WinSetDrawWindow(workH); 
           RctSetRectangle(rPtr, 
             pSch->x/Zoom, 
             pSch->y/Zoom, 
             (pSch->w/Zoom)+1, 
             (pSch->h/Zoom)+1); 
 
           WinEraseRectangle(rPtr,0); 
           WinSetDrawWindow(mainH); 
           break; 
 
  }  
 
  DisplaySheet(workH,SheetX,SheetY,grid); 
  MemPtrFree(rPtr); 
 
} 
 
void UndoFromSheet(WinHandle workH) 
{ 
  int LastRec; 
  SCHDB *pSch; 
 
  LastRec=DmNumRecords(SCHdb)-1; 
  if(LastRec<1) return; 
 
  pSch = MemPtrNew(sizeof(SCHDB)); 
  ReadSchDB(SCHdb,LastRec,pSch); 
  DmRemoveRecord(SCHdb, LastRec); 
  EraseComponent(workH,pSch); 
 
  MemPtrFree(pSch); 
       
} 
 
int CrossDetect(int tx,int ty,int x1,int y1,int x2,int y2) 
{ 
 
  int xd,yd; 
 
  if(tx>x1) xd=tx-x1; else xd=x1-tx; 
  if(ty>y1) yd=ty-y1; else yd=y1-ty; 
  if(xd<4&&yd<4) return 1; 
 
  if(y1==y2&&yd<4&&x2>x1&&tx>x1&&tx<x2) return 1; 
  if(y1==y2&&yd<4&&x1>x2&&tx>x2&&tx<x1) return 1; 
  if(x1==x2&&xd<4&&y2>y1&&ty>y1&&ty<y2) return 1; 
  if(x1==x2&&xd<4&&y1>y2&&ty>y2&&ty<y1) return 1; 
 
  return 0; 
 
} 
 
void DeleteFromSheet(WinHandle workH) 
{ 
  WinHandle mainH; 
  RectanglePtr rPtr; 
  int x,y,w,h; 
  int df=0,dx,dy,f=0,xd,yd,snap=4; 
  Boolean t; 
  SCHDB *pSch; 
  char buf[20]; 
 
  rPtr=MemPtrNew(sizeof(RectangleType)); 
  pSch = MemPtrNew(sizeof(SCHDB)); 
 
  do { 
    EvtGetPen(&dx,&dy,&t);  
    dx=dx*snap/snap;dy=dy*snap/snap; 
  } while(t); 
 
  df=0;  
  dx=(dx+SheetX)*Zoom;  
  dy=(dy+SheetY)*Zoom; 
 
  MsgWin("Deleting..."); 
  
  // check records for a match... 
  for(f=0;f<=DmNumRecords(SCHdb);f++) { 
    if(!ReadSchDB(SCHdb,f,pSch))  
      continue; 
 
    x=pSch->x; y=pSch->y; 
    w=pSch->w; h=pSch->h; 
 
    switch(pSch->type) 
    { 
 
      case C_JUNCTION: // points 
 
           if(dx>x) xd=dx-x; else xd=x-dx; 
           if(dy>y) yd=dy-y; else yd=y-dy; 
           if(xd<4&&yd<4) df=1; 
           break; 
 
      case C_WIRE:  // lines 
      case C_BUS: 
 
           df=CrossDetect(dx,dy,x,y,w,h); 
           break; 
 
      case C_USERLIB: // blocks 
      case C_BITMAP: 
      case C_LABEL: 
 
           if(dx>=x&&dx<=(w+x) && 
              dy>=y&&dy<=(h+y)) df=1; 
             break; 
    }  
  
    if(df) break;    
  } 
 
  if(df) { 
    DmRemoveRecord(SCHdb, f); 
    EraseComponent(workH,pSch); 
  } 
  else SndPlaySystemSound(1); 
 
  DisplaySheet(workH,SheetX,SheetY,grid); 
  MemPtrFree(rPtr); 
  MemPtrFree(pSch); 
 
} 
 
// ------------------------------------  
//         SHEET INITIALISATION 
// ------------------------------------ 
 
static void SheetInit(void)  
{  
 
  FormPtr frmP; 
  PreferenceType prefs;  
  Word prefsSize;  
  char buffer[100]; 
  int color=0; 
 
  // Read the saved preferences / saved-state information.  
  prefsSize = sizeof(PreferenceType);  
 
  if (PrefGetAppPreferences(appFileCreator, appPrefID, &prefs, &prefsSize, true) !=   
		noPreferenceFound) { 
    SheetX=prefs.x; 
    SheetY=prefs.y; 
    grid=prefs.grid; 
    Zoom=prefs.zoom; 
    Ortho=prefs.ortho; 
    StrCopy(FileName,prefs.fname); 
 
    if(Zoom>ZOOM4) Zoom=ZOOM1; 
    if(!Ortho) SetControlState(OrthoButton,0); 
    if(!grid) SetControlState(GridButton,0); 
 
  }  
 
  else { 
    StrCopy(FileName,"untitled.sch"); 
    SCHdb=NewDB(FileName,appFileCreator,'dsch'); 
    SetVersion(FileName,dataVersion); 
    CloseDB(SCHdb); 
  } 
 
  SheetHandle = CreateSheet(SheetW,SheetH); 
  SCHdb = OpenDB(FileName); 
  if(!SCHdb) { 
    SCHdb=NewDB(FileName,appFileCreator,'dsch'); 
    SetVersion(FileName,dataVersion); 
  } 
 
  DrawSheet(SheetHandle); 
  DisplaySheet(SheetHandle,SheetX,SheetY,grid); 
 
}  
 
// ------------------------------------  
//            SHEET INFO 
// ------------------------------------ 
 
void SheetInfo(void) 
{ 
  char buff[40],buff2[40]; 
  int c=0,i=0,f; 
  SCHDB *pSch; 
 
  pSch = MemPtrNew(sizeof(SCHDB)); 
 
  for(f=0;f<=DmNumRecords(SCHdb);f++) { 
    if(!ReadSchDB(SCHdb,f,pSch))  
      continue; 
    if(pSch->type==C_BITMAP&&pSch->id>2019) c++; 
    if(pSch->type==C_USERLIB) i++; 
  } 
 
  if(DmNumRecords(SCHdb)==0) { 
    i=0; c=0; 
  } 
 
  StrPrintF(buff2,"Components= %d",c); 
  StrPrintF(buff,"ICs= %d",i); 
  FrmCustomAlert(InfoAlert,FileName,buff,buff2); 
 
  MemPtrFree(pSch); 
 
} 
 
// ------------------------------------  
//      MAIN-FORM MENU PROCESS 
// ------------------------------------ 
 
static Boolean MainFormMenuProcess(Word command)  
{  
  Boolean handled = false;  
  FormPtr frmP, frm2P; 
  Word Fid;  
  WinHandle mainH; 
  char buffer[40]; 
  char *pName, OldName[40]; 
  int r,i; 
  LocalID id; 
 
  switch (command)  
  {  
 
	case MenuFileNew: 
          if(AskBox(AskAlert,"New untitled.sch?")==0) 
          { 
  		  CloseDB(SCHdb); 
            StrCopy(FileName,"untitled.sch");  
		  SCHdb = NewDB(FileName,appFileCreator,'dsch'); 
            SetVersion(FileName,dataVersion); 
 
            if(ColorSupport()) BmpDelete(workB); 
            if(OS5) BmpDelete(mainB); 
            
            WinDeleteWindow(SheetHandle,1); 
            SheetHandle = CreateSheet(SheetW,SheetH); 
  		  DrawSheet(SheetHandle); 
		  SheetX=0;SheetY=0; 
            DisplaySheet(SheetHandle,SheetX,SheetY,grid); 
          } 
 
		handled = true;  
          break; 
 
	case MenuFileOpen: 
 
          if(SelectFile(buffer)) { 
		  SheetX=0;SheetY=0; 
  		  CloseDB(SCHdb); 
            StrCopy(FileName,buffer); 
            SCHdb=OpenDB(FileName); 
            MsgWin("  Loading..."); 
            ResetMode(); 
            DrawSheet(SheetHandle); 
            DisplaySheet(SheetHandle,SheetX,SheetY,grid); 
 
          } 
 
		handled = true;  
		break; 
 
	case MenuFileRename:           
 		frmP = FrmGetActiveForm();  
		frm2P=FrmInitForm(RenameForm); 
          FrmSetActiveForm(frm2P); 
          SetTextToObject(RenameField, FileName); 
		r=FrmDoDialog(frm2P); 
 
          if(r==OKButton) { 
            pName=GetTextFromObject(RenameField); 
 
  		  CloseDB(SCHdb); 
            StrCopy(OldName,FileName); 
            StrCopy(FileName,pName); 
 
            if(StrStr(FileName,".sch")==NULL)  
              AddStr(FileName,".sch"); 
 
            if(RenameDB(OldName,FileName)==0) { 
              ErrorBox("File already exists!",NULL); 
              StrCopy(FileName,OldName); 
            } 
            SCHdb=OpenDB(FileName); 
          } 
 
          FrmSetActiveForm(frmP); 
		FrmDeleteForm(frm2P); 
 		FrmDrawForm (frmP); 
          DisplaySheet(SheetHandle,SheetX,SheetY,grid); 
		handled = true;  
		break;  
 
	case MenuFileDelete: 
          if(AskBox(AskAlert,"Delete schematic?")==0) 
          { 
            CloseDB(SCHdb); 
            DeleteDB(FileName); 
            StrCopy(FileName,"untitled.sch"); 
            SCHdb=NewDB(FileName,appFileCreator,'dsch'); 
            SetVersion(FileName,dataVersion); 
 
            if(ColorSupport()) BmpDelete(workB); 
            if(OS5) BmpDelete(mainB); 
                        
            WinDeleteWindow(SheetHandle,1); 
            SheetHandle = CreateSheet(SheetW,SheetH); 
		  SheetX=0;SheetY=0; 
  		  DrawSheet(SheetHandle); 
            DisplaySheet(SheetHandle,SheetX,SheetY,grid); 
          } 
		handled = true;  
          break; 
 
	case MenuSheetInfo: 
          SheetInfo(); 
		handled = true;  
		break; 
 
	case MenuExportBitmap: 
          SaveBitmap(SheetHandle); 
		handled = true;  
		break; 
 
	case MenuSheetErase: 
          if(AskBox(AskAlert,"Erase schematic?")==0) 
          { 
  		  CloseDB(SCHdb); 
            DeleteDB(FileName); 
            SCHdb=NewDB(FileName,appFileCreator,'dsch'); 
            SetVersion(FileName,dataVersion); 
 
            if(ColorSupport()) BmpDelete(workB); 
            if(OS5) BmpDelete(mainB); 
            
            WinDeleteWindow(SheetHandle,1); 
            SheetHandle = CreateSheet(SheetW,SheetH); 
		  SheetX=0;SheetY=0; 
  		  DrawSheet(SheetHandle); 
            DisplaySheet(SheetHandle,SheetX,SheetY,grid); 
          } 
		handled = true;  
          break; 
 
	case MenuOptionsAbout:  
		MenuEraseStatus (0);  
          FrmCustomAlert(AboutAlert,NULL,NULL,NULL); 
          DisplaySheet(SheetHandle,SheetX,SheetY,grid); 
		handled = true;  
		break;  
 
     case MenuOptionsHelp: 
          FrmHelp(HelpMsg); 
          DisplaySheet(SheetHandle,SheetX,SheetY,grid); 
		handled = true;  
		break;  
 
     case MenuExportBlock: 
          ExportBlock(); 
          ResetMode(); 
		handled = true;  
		break;  
 
     case MenuImportBlock: 
          ImportBlock(); 
          ResetMode(); 
		handled = true;  
		break;  
 
  }  
  return handled;  
}  
 
// ------------------------------------  
//      MAIN-FORM CONTROLS PROCESS 
// ------------------------------------ 
 
static Boolean MainFormControlProcess(Word controlID) 
{ 
 
  SCHDB *pSch; 
  WinHandle mainH; 
  int r,x,y,x2,y2, LastRec; 
 
  char buf[80]; 
 
  Boolean handled = false; 
   
  if(HiZoom) { 
    ResetMode(); 
    handled=true; 
    break; 
  } 
   
  switch (controlID)   
  {  
 
      case PanButton: 
           EditMode=PANMODE; 
           placeID=0;placeF=0; 
           handled = true; 
           break; 
 
      case SelButton: 
           EditMode=SELMODE; 
           TargetX=-1; TargetY=-1; 
           RegionX=0; RegionY=0; 
           RegionX2=0; RegionY2=0; 
           placeID=0; placeF=0; 
           handled = true; 
           break; 
 
      case WireButton: 
           EditMode=WIREMODE; 
           placeID=0; 
           handled = true; 
           break; 
 
      case BusButton: 
           EditMode=BUSMODE; 
           placeID=0; 
           handled = true; 
           break; 
 
      case JunButton: 
           EditMode=JUNMODE; 
           placeID=0; 
           handled = true; 
           break; 
 
      case UndoButton: 
           if(!placeID) UndoFromSheet(SheetHandle); 
           handled = true; 
           break; 
 
      case CopyButton: 
           if(EditMode==SELMODE) BlockOper=COPYBLOCK; 
           else SndPlaySystemSound(1); 
           handled = true; 
           break; 
 
      case GridButton: 
           if(grid) grid=0; 
           else grid=GRIDSPACE; 
           DisplaySheet(SheetHandle,SheetX,SheetY,grid); 
           handled = true; 
           break;    
 
      case OrthoButton: 
           if(Ortho) Ortho=0; 
           else Ortho=1; 
           handled = true; 
           break;   
 
      case LabelButton: 
           EditMode=ALPHAMODE; 
           placeID=0; 
           handled = true; 
           break;     
 
      case DelButton: 
           if(EditMode==SELMODE) { 
             BlockOper=DELBLOCK; 
             x=(SheetX+RegionX)*Zoom; 
             y=(SheetY+RegionY)*Zoom; 
             x2=x+(RegionX2*Zoom); 
             y2=y+(RegionY2*Zoom); 
             TargetX=x; TargetY=y; 
 
             WriteBlock(SCHdb,SCHdb,BlockOper,TargetX,  
               TargetY,x,y,x2,y2); 
 
             BlockOper=MOVEBLOCK; 
             TargetX=-1; TargetY=-1; 
             RegionX=0; RegionY=0; 
             RegionX2=0;RegionY2=0; 
 
             SetControlState(DelButton,0);              
             SetControlState(SelButton,1);              
           } 
           else EditMode=DELMODE; 
 
           placeID=0;placeF=0; 
           handled = true; 
           break;     
 
      case OrientButton: 
           if(placeID!=LIBID&&placeID>0) { 
             placeID++; 
             if(GetBitmapSize(placeID,&x,&y)==0) 
               placeID=baseID;  
             DisplaySheet(SheetHandle,SheetX,SheetY,grid);      
             DrawComponent(DRAWFG,SheetHandle,placeID,0,placeN,placeX,placeY); 
 
           } 
           else if(placeID==LIBID&&placeID>0) { 
             if(placeF) placeF=0; 
             else placeF=1; 
             DisplaySheet(SheetHandle,SheetX,SheetY,grid);      
             DrawComponent(DRAWFG,SheetHandle,placeID,placeF,placeN,placeX,placeY); 
           } 
 
           else SndPlaySystemSound(1); 
 
           handled = true; 
           break; 
 
      case PlaceButton: 
 
           if(EditMode==WIREMODE) { 
             RepeatTrace(); 
             handled = true; 
             break; 
           } 
 
           if(EditMode==SELMODE) { 
             x=(SheetX+RegionX)*Zoom; 
             y=(SheetY+RegionY)*Zoom; 
             x2=x+(RegionX2*Zoom); 
             y2=y+(RegionY2*Zoom); 
             TargetX=(SheetX+TargetX)*Zoom; 
             TargetY=(SheetY+TargetY)*Zoom; 
     
             WriteBlock(SCHdb,SCHdb,BlockOper,TargetX,  
               TargetY,x,y,x2,y2); 
 
             BlockOper=MOVEBLOCK; 
             TargetX=-1; TargetY=-1; 
             RegionX=0; RegionY=0; 
             RegionX2=0;RegionY2=0; 
             placeF=0; 
 
             handled = true; 
             break; 
           } 
 
           if(placeID) PlaceObject(placeF); 
           else SndPlaySystemSound(1); 
 
           handled = true; 
           break;     
 
      case ICButton: 
           if(placeID) PlaceObject(placeF); 
           if(GetLibComponent(placeN)) { 
             placeID=LIBID;  
             placeX=SheetX;  
             placeY=SheetX; 
             OldMode=EditMode; 
             EditMode=PANMODE;   
           } 
 
           else { 
             EditMode=PANMODE; 
             SetControlState(PanButton,1);              
             SetControlState(ICButton,0); 
           } 
 
           handled = true; 
           break;  
 
      case SymButton: 
           if(placeID) PlaceObject(0); 
           r=GetSymbol(SymbolList); 
           if(r) { 
             placeID=r;  
             placeX=SheetX;  
             placeY=SheetX; 
             OldMode=EditMode; 
             EditMode=PANMODE;   
           } 
 
           else { 
             EditMode=PANMODE; 
             SetControlState(PanButton,1);              
             SetControlState(SymButton,0); 
           } 
 
           handled = true; 
           break;  
 
      case GateButton: 
           if(placeID) PlaceObject(0); 
           r=GetSymbol(GateList); 
           if(r) { 
             placeID=r;  
             placeX=SheetX;  
             placeY=SheetX; 
             OldMode=EditMode; 
             EditMode=PANMODE;   
           } 
 
           else { 
             EditMode=PANMODE; 
             SetControlState(PanButton,1);              
             SetControlState(GateButton,0); 
           } 
 
           handled = true; 
           break;  
 
      case ElectButton: 
           if(placeID) PlaceObject(0); 
           r=GetSymbol(ElectList); 
           if(r) { 
             placeID=r;  
             placeX=SheetX;  
             placeY=SheetX; 
             OldMode=EditMode; 
             EditMode=PANMODE;   
           } 
 
           else { 
             EditMode=PANMODE; 
             SetControlState(PanButton,1);              
             SetControlState(ElectButton,0); 
           } 
 
           handled = true; 
           break;     
 
  } 
  return handled; 
}	 
  
// ------------------------------------  
//          MAIN-FORM HANDLER 
// ------------------------------------ 
 
static Boolean MainFormHandleEvent(EventPtr eventP)  
{  
  DWord k; 
  ListPtr l; 
  int t,snap; 
  FormPtr frmP;  
  
  switch (eventP->eType)   
  {  
     
	case frmOpenEvent:  
		frmP = FrmGetActiveForm();  
 		FrmDrawForm(frmP); 
		SheetInit(); 
		return true;  
  
	case menuEvent:  
		return MainFormMenuProcess(eventP->data.menu.itemID);   
 
     case ctlSelectEvent: 
          return MainFormControlProcess(eventP->data.ctlSelect.controlID); 
 
     case penDownEvent: 
          if(eventP->screenY>148) return false; 
 
          switch (EditMode) { 
 
      	  case SELMODE: 
                 SelectRegion(); 
                 return true; 
      
      	  case PANMODE: 
               if(OS5)  
    	        t=PanSheet(SheetHandle,2,4,&SheetX,&SheetY); 
               else 
                 t=PanSheet(SheetHandle,4,GRIDSPACE,&SheetX,&SheetY); 
     
                 if(placeID) { 
                   if(t==0) { 
                     snap=4; 
                     if(placeID==LIBID&&Zoom==ZOOM1) snap=8; 
                     EvtGetPen(&placeX,&placeY,&t); 
                     placeX=placeX+SheetX;  
                     placeY=placeY+SheetY; 
                     placeX=placeX/snap*snap;  
                     placeY=placeY/snap*snap; 
                     if(placeID==LIBID) placeX-=(16/Zoom);        
                   } 
 
                   DisplaySheet(SheetHandle,SheetX,SheetY,grid);      
                   DrawComponent(DRAWFG,SheetHandle,placeID,0,placeN,placeX,placeY); 
                 } 
                 return true; 
 
      	  case WIREMODE: 
                 EnterWire(SheetHandle,4,THINLINE); 
                 return true; 
 
      	  case BUSMODE: 
                 EnterWire(SheetHandle,4,THICKLINE); 
                 return true; 
 
      	  case JUNMODE: 
           	  EnterJunction(SheetHandle,4); 
           	  break; 
 
      	  case ALPHAMODE: 
                 EnterLabel(SheetHandle,4);    
                 return true; 
 
      	  case DELMODE: 
                 DeleteFromSheet(SheetHandle); 
                 return true; 
 
 	     } 
 
     case keyDownEvent: 
          k=KeyCurrentState(); 
/* 
          l=GetObjectPtr(FileList);            
          if(k==keyBitPageUp) 
          LstScrollList(l,up,8); 
          if(k==keyBitPageDown) 
          LstScrollList(l,down,8); 
*/ 
          // Zoom out 
          if(k==keyBitPageDown) { 
           
               if(HiZoom)   { 
                  HiZoom=0; 
                  Zoom=ZOOM1; 
                  ShowControls(); 
                  DrawSheet(SheetHandle); 
                  return true; 
               } 
               
            Zoom=Zoom*2; 
 
            if(Zoom>ZOOM4) { 
              Zoom=ZOOM4; 
              SndPlaySystemSound(1); 
            } 
            else { 
              SheetX=SheetX/2; 
              SheetY=SheetY/2; 
              RegionX=0; RegionY=0; 
              RegionX2=0;RegionY2=0; 
 
              DrawSheet(SheetHandle); 
 
              if(placeID) { 
                placeX=placeX/2;placeY=placeY/2; 
                DrawComponent(DRAWFG,SheetHandle,placeID,0,placeN,placeX,placeY); 
              } 
            } 
          } 
 
          // Zoom in 
          if(k==keyBitPageUp) {           
  
              if(HiZoom)   { 
                  SndPlaySystemSound(1); 
                  return true; 
             }          
                
             if(Zoom==ZOOM1&&OS5)   { 
                HiZoom=1; 
                SheetX=0; SheetY=0; 
                ResetMode();
                HideControls(); 
                DrawSheet(SheetHandle); 
                return true; 
               
              } 
                    
            if(Zoom>ZOOM1) { 
              Zoom=Zoom/2; 
              SheetX=SheetX*2; 
              SheetY=SheetY*2; 
              RegionX=0; RegionY=0; 
              RegionX2=0;RegionY2=0; 
 
              DrawSheet(SheetHandle); 
 
              if(placeID) { 
                placeX=placeX*2;placeY=placeY*2; 
                DrawComponent(DRAWFG,SheetHandle,placeID,0,placeN,placeX,placeY); 
              } 
            } 
            else SndPlaySystemSound(1); 
          } 
 
          return true; 
 
    }	  
   	  
  return false;  
}  
  
// ------------------------------------  
//          APP HANDLE EVENT 
// ------------------------------------ 
 
 
static Boolean AppHandleEvent( EventPtr evtP) 
{ 
  int x,y; 
  Boolean t; 
  Word formId; 
  FormPtr frmP; 
 
  switch(evtP->eType) { 
 
  case frmLoadEvent: 
   
       formId = evtP->data.frmLoad.formID; 
       frmP = FrmInitForm(formId); 
       FrmSetActiveForm(frmP); 
       FrmSetEventHandler (frmP, MainFormHandleEvent); 
 
       return true; 
  } 
 
  return false; 
} 
 
// ------------------------------------  
//           APP EVENT LOOP 
// ------------------------------------ 
 
 
static void AppEventLoop(void) 
{ 
  Word error; 
  EventType evt; 
 
  do 
  { 
	EvtGetEvent(&evt, evtWaitForever); 
	if (! SysHandleEvent(&evt)) 
	  if (! MenuHandleEvent(0, &evt, &error)) 
  	    if (! AppHandleEvent(&evt)) 
	      FrmDispatchEvent(&evt); 
  }  
  while (evt.eType !=appStopEvent); 
 
} 
 
 
// ------------------------------------  
//              APP STOP 
// ------------------------------------ 
 
void SavePrefs(char *fname, int x, int y, int g) 
{ 
  PreferenceType prefs;  
     
  prefs.x=x; 
  prefs.y=y; 
  prefs.grid=grid; 
  prefs.zoom=Zoom; 
  prefs.ortho=Ortho; 
  StrCopy(prefs.fname,fname); 
 
  // Write the saved preferences  
  PrefSetAppPreferences (appFileCreator, appPrefID, appPrefVersionNum,   
		&prefs, sizeof (prefs), true);  
 
 
} 
 
static void AppStop(void)  
{  
     
  SavePrefs(FileName,SheetX,SheetY,grid); 
  CloseDB(SCHdb);  
  FrmCloseAllForms(); 
 
}  
 
// ------------------------------------  
//              M A I N 
// ------------------------------------ 
 
 
DWord PilotMain( Word cmd, Ptr cmdPBP, Word launchFlags)  
{ 
  FONTFILE *pFnt; 
  Word fID; 
  Handle fntH; 
  UInt32 v;
 
  switch (cmd) 
  { 
    case sysAppLaunchCmdNormalLaunch: 
  
       if(GetOS()>0x0049) {
         FtrGet(sysFtrCreator,sysFtrNumWinVersion,&v);
         if(v>=4)  OS5=1;  // high density OS5
      }
      
      fntH = GetTinyFont(128); 
 
      if(fntH) { 
        fID  = FntSetFont(128); 
        CreateSample(); 
	   FrmGotoForm(MainForm); 
	   AppEventLoop(); 
	   AppStop(); 
 
        FntSetFont(fID); 
        DiscardTinyFont(fntH); 
      } 
       else ErrorBox("Error loading","TinyFont"); 
	 break; 
 
    default: 
	 break; 
  } 
  return 0; 
} 
  
